"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "verifyRootLayout", {
    enumerable: true,
    get: function() {
        return verifyRootLayout;
    }
});
const _path = /*#__PURE__*/ _interop_require_default(require("path"));
const _log = /*#__PURE__*/ _interop_require_wildcard(require("../build/output/log"));
const _fs = require("fs");
const _picocolors = require("./picocolors");
const _constants = require("./constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const globOrig = require('next/dist/compiled/glob');
const glob = (cwd, pattern)=>{
    return new Promise((resolve, reject)=>{
        globOrig(pattern, {
            cwd
        }, (err, files)=>{
            if (err) {
                return reject(err);
            }
            resolve(files);
        });
    });
};
function getRootLayout(isTs) {
    if (isTs) {
        return `export const metadata = {
  title: 'Next.js',
  description: 'Generated by Next.js',
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en">
      <body>{children}</body>
    </html>
  )
}
`;
    }
    return `export const metadata = {
  title: 'Next.js',
  description: 'Generated by Next.js',
}

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <body>{children}</body>
    </html>
  )
}
`;
}
async function verifyRootLayout({ dir, appDir, tsconfigPath, pagePath, pageExtensions }) {
    let rootLayoutPath;
    try {
        const layoutFiles = await glob(appDir, `**/layout.{${pageExtensions.join(',')}}`);
        const isFileUnderAppDir = pagePath.startsWith(`${_constants.APP_DIR_ALIAS}/`);
        const normalizedPagePath = pagePath.replace(`${_constants.APP_DIR_ALIAS}/`, '');
        const pagePathSegments = normalizedPagePath.split('/');
        // Find an available dir to place the layout file in, the layout file can't affect any other layout.
        // Place the layout as close to app/ as possible.
        let availableDir;
        if (isFileUnderAppDir) {
            if (layoutFiles.length === 0) {
                // If there's no other layout file we can place the layout file in the app dir.
                // However, if the page is within a route group directly under app (e.g. app/(routegroup)/page.js)
                // prefer creating the root layout in that route group.
                const firstSegmentValue = pagePathSegments[0];
                availableDir = firstSegmentValue.startsWith('(') ? firstSegmentValue : '';
            } else {
                pagePathSegments.pop() // remove the page from segments
                ;
                let currentSegments = [];
                for (const segment of pagePathSegments){
                    currentSegments.push(segment);
                    // Find the dir closest to app/ where a layout can be created without affecting other layouts.
                    if (!layoutFiles.some((file)=>file.startsWith(currentSegments.join('/')))) {
                        availableDir = currentSegments.join('/');
                        break;
                    }
                }
            }
        } else {
            availableDir = '';
        }
        if (typeof availableDir === 'string') {
            const resolvedTsConfigPath = _path.default.join(dir, tsconfigPath);
            const hasTsConfig = await _fs.promises.access(resolvedTsConfigPath).then(()=>true, ()=>false);
            rootLayoutPath = _path.default.join(appDir, availableDir, `layout.${hasTsConfig ? 'tsx' : 'js'}`);
            await _fs.promises.writeFile(rootLayoutPath, getRootLayout(hasTsConfig));
            _log.warn(`Your page ${(0, _picocolors.bold)(`app/${normalizedPagePath}`)} did not have a root layout. We created ${(0, _picocolors.bold)(`app${rootLayoutPath.replace(appDir, '')}`)} for you.`);
            // Created root layout
            return [
                true,
                rootLayoutPath
            ];
        }
    } catch (e) {
        console.error(e);
    }
    // Didn't create root layout
    return [
        false,
        rootLayoutPath
    ];
}

//# sourceMappingURL=verify-root-layout.js.map